Version 1/191217 of Under They Thunder Globals by Andrew Schultz begins here.

"Under They Thunder Globals: this is part of an effort to clean up my code some more. This file can be opened next to story.ni in notepad to give a clearer version of what goes where. It should be used to define variables, which are meant to be descriptive. To check if variables are defined in story.ni, run utg.py. To check that the maximum score matches up, run pts.py."

volume global definitions

this is the trivially false rule: the rule fails;

this is the trivially true rule: the rule succeeds;

to say email: say "blurglecrun[hc]eon@gmail.com"

to say hc: say "ch"

to say github: say "http://github.com/andrewschultz/under-they-thunder"

to bold-note (x - text): say "[bracket][b]NOTE:[r] [x][close bracket][paragraph break]"

to say bug-together: say "BUG: [the item described] should have an initial appearance together with another person or thing"

section MYSTERIOUS ENTITIES

a concept is a kind of thing. the description of a concept is "This is something only referred to in the actual game."

the Flame Lame Fey is a concept. printed name is "Flame-Lame Fey".

the Factual Actual Fey is a concept. printed name is "Factual-Actual Fey".

the Fight Ite Fey is a concept. printed name is "Fight-Ite Fey".

book regions and starting rooms

book regions

a region can be omable. a region is usually omable.

a region has a room called last-room. last-room of a region is usually Start Art Stay. [this is very wrong, but it quickly gets re-initialized before we need it]

a region has text called reach-abbrev.

Am Hey Ham is a not omable region. printed name is "Am-Hey-Ham".

Brain Reign Bay is a region. reach-abbrev is "rb".

Clout Lout Cay is a region. reach-abbrev is "rc".

Old Fey Fold is a region. reach-abbrev is "rf".

Eee Say Sea is a region. reach-abbrev is "ri".

Laden Aidin' Ley is a region. reach-abbrev is "rl". printed name is "Laden-Aidin['] Ley".

Un Fey Fun is a not omable region.

to decide which region is mrlp:
	decide on map region of location of player;

Start Art Stay is a room in Am Hey Ham.

book room definitions and functions

a room has text called noway-text.

a room has text called gen-desc. gen-desc of a room is usually "<SOMEWHERE>".

a room can be preray, rayable, rayed, raydone or normal. a room is usually normal.

a room can be wally. a room is usually not wally.

a beachroom is a kind of room. A beachroom has a direction called indir. indir of a beachroom is usually up. [e.g. there is no in-dir. Otherwise, it is specified as NSEW.]

a puzroom is a kind of room.

a puzroom can be finished. a puzroom is usually not finished.

an isleroom is a kind of beachroom.

definition: an isleroom (called ir) is thought-yet:
	repeat through table of isle guesses:
		if myrm entry is ir:
			if tried-yet entry is true, yes;
		break;
	no;

a room has text called shorttext.

a room has a rule called done-room-rule. done-room-rule of a room is usually the trivially false rule.

a room has a rule called block-room-rule. block-room-rule of a room is usually the trivially false rule.

a room can be beachy. a room is usually not beachy.

a room can be renameable. a room is usually not renameable.

a room can be altnamed. a room is usually not altnamed.

a room can be ever-alt. a room is usually not ever-alt.

to move-if-not (rm - a room): if player is not in rm, move player to rm;

chapter printing shortname

for printing the name of a room (called rm) when opt-short-names is true and shorttext of rm is not empty and rm is visited: say "[shorttext of the item described]".

after printing the name of a room (called rm) when opt-track-done is true:
	if rm is useless:
		say " (useless)";
		continue the action;
	process the done-room-rule of rm;
	if the rule succeeded, say " (done)"

definition: a room (called rm) is useless:
	if rm is Ovel Nay Novel, yes;
	no;

chapter thing properties

a thing can be examined. a thing is usually not examined.

a thing can be automatic, songy, booky, needy, useful, twoway, moody, complex, loneuse, mystical or ordinary. a thing is usually ordinary. [this is for the please-ease-play]

to pepl (th - a thing):
	say "[line break]";
	pep th;

to pep (th - a thing):
	if th is a thing:
		if th is needy:
			say "You could probably use an item on [th].";
		else if th is useful:
			say "You could probably use [the th] on something.";
		else:
			say "You can't seem to do anything with [th].";
	if th is a person:
		say "[if th is songy]A song[else if th is booky]The wisdom of writing[else if th is needy]a gift[else if th is complex]more than one thing[else if th is useful]Using it on something[else if th is twoway]Using it on something and using something on it[else if th is ordinary]Nothing offhand[end if] could help you deal with [th].";


section latinable

a latinable is a kind of thing. a latinable is usually scenery.

a latinable has text called preuse-text.

a latinable has a table name called guess-table.

a latinable has text called clue-chunk. clue-chunk of a latinable is usually "index".

a latinable has text called clue-chunk-plural. clue-chunk-plural of a latinable is usually "indices".

a latinable has text called help-verb.

a latinable has text called midpart. midpart of a latinable is usually " ".

a latinable has text called startpart. startpart of a latinable is usually "".

a latinable has a rule called known-rule. known-rule of a latinable is usually the NOTE THIS rule

this is the NOTE THIS rule:
	say "NOTE TO SELF: you need to replace a default rule here.";

to print-done-guessed (la - a latinable):
	repeat through guess-table of la:
		if can-work entry is false, next;
		if la is hip say ship, say "Isle ";
		if tried-yet entry is true or worked-yet entry is true:
			say "[firstof of w1 entry][midpart of la][firstof of w2 entry]";
		else if startpart of la is not empty:
			say "[startpart of la](?) (?)";
		else:
			say "(?)[no line break][midpart of la](?) ";
		if tried-yet entry is true and worked-yet entry is false:
			say "(try later) ";
		say "[line break]";

section bookshelves

a bookshelf is a kind of thing. a bookshelf is usually scenery.

section songs

a song is a kind of thing. a song is usually scenery.

for printing the name of a song (called the item): say "[i][printed name of item][r]"

last-song is a song that varies.

after examining a song:
	say "You'll keep [noun] in your head for a bit.";
	now last-song is noun;
	continue the action;

section startbooks

a plainbook is a kind of thing.

for printing the name of a plainbook (called the item): say "[i][printed name of item][r]"

section helpbooks

a helpbook is a kind of plainbook. a helpbook is usually scenery.

a helpbook has text called summary-text.

a helpbook has a rule called help-useful-rule. help-useful-rule of a helpbook is usually the NOTE THIS rule.

a helpbook has a rule called finished-reading-rule. finished-reading-rule of a helpbook is usually the NOTE THIS rule.

a helpbook can be start-shelved or start-unshelved. a helpbook is usually start-shelved.

for printing the name of a helpbook (called the item): say "[i][printed name of item][r]"

section pagedbooks

a pagedbook is a kind of plainbook. a pagedbook is usually scenery.

a pagedbook has a number called cur-page. cur-page of a pagedbook is usually 0.

a pagedbook can be fully-read. a pagedbook is usually not fully-read.

a pagedbook can be ever-read. a pagedbook is usually not ever-read.

a pagedbook has a table name called book-pages.

to decide what number is total-pages of (h - a pagedbook):
	decide on number of rows in book-pages of h;

after examining a pagedbook:
	let tp be total-pages of noun;
	if tp is 0, continue the action;
	if cur-page of the noun is 0:
		say "You haven't read [noun] yet at all. It has [tp] pages.";
	else if the noun is fully-read:
		say "You've read [noun] fully, all [tp] pages.";
	else:
		say "You left off reading [noun] on page [cur-page of noun] of [tp].";

section win trays

[I'd like to define this with items, but since rooms need to have win-trays, this needs to come first.]

a win-tray is a kind of thing.

a win-tray can be sorted-yet. a win-tray is usually not sorted-yet.

a win-tray can be warned. a win-tray is usually not warned.

section ingredients

[these are for Feedin' Eden Faye]

an ingredient is a kind of thing. an ingredient is usually edible. an ingredient is usually useful. the initial appearance of an ingredient is usually "I should have sent [the item described] directly to your inventory, so it is a bug to see it lying here. You can probably just take it, though."

chapter trayrooms

a trayroom is a kind of isleroom. a trayroom has a number called right-trays. a trayroom has a win-tray called wt1. a trayroom has a win-tray called wt2. a trayroom has a number called got-right.

a trayroom can be finished or unfinished. a trayroom is usually not finished.

to blot-out (X - a trayroom) and (Y - a win-tray):
	repeat through table of traytries:
		if trm entry is X and mytray entry is Y:
			if debug-state is true, say "[X] repels [Y].";
			now validtry entry is false;
			continue the action;
	say "UH OH failed to blot out [X] and [Y]. This is a big bug.";

[OLD: wangle angle, clog log, stare air ??]

table of traytries
trm	mytray	validtry	triedyet
West Est Way	ace tray	true	false
West Est Way	ends tray	true	false
West Est Way	icky tray	true	false
West Est Way	ol' tray	true	false
West Est Way	rusting tray	true	false
West Est Way	eyeing tray	true	false
Beast East Bay	ace tray	true	false
Beast East Bay	ends tray	true	false
Beast East Bay	icky tray	true	false
Beast East Bay	ol' tray	true	false
Beast East Bay	rusting tray	true	false
Beast East Bay	eyeing tray	true	false
Isle Tray Trial	ace tray	true	false
Isle Tray Trial	ends tray	true	false
Isle Tray Trial	icky tray	true	false
Isle Tray Trial	ol' tray	true	false
Isle Tray Trial	rusting tray	true	false
Isle Tray Trial	eyeing tray	true	false

table of trayclues
t1	t2	trayclue
ace tray	ends tray	"buoying, symposiums, bodysurfing, whodunitry, outlying, currycombing, and onychiums"
ace tray	icky tray	"costumery, gurgoyles, euphony, countermyths, joyfulness, cynosures, and purveyors"
ace tray	ol' tray	"equity, yuppies, dubiety, surveying, fruitery, myceliums, triumphery, and Ytterbium"
ace tray	rusting tray	"hosiery, isozymes, bogeyism, obesity, jockeying, posterity, and hypnotizers"
ace tray	eyeing tray	"bougies, couriers, pirogues, outsiders, poutines, timeouts, and coiffures"
ends tray	icky tray	"bayous, payouts, autonyms, grayhounds, hautboys, and mulloways"
ends tray	ol' tray	"duality, fatuity, absurdity, brutality, maturity and suavity"
ends tray	rusting tray	"hypoxia, isoamyls, joviality, holidays, diplomacy, mortality and oligarchy"
ends tray	eyeing tray	"audio, ouijas, utopia, rainouts, ossariums, tutorials and touristas"
icky tray	ol' tray	"beauty, aneurysms, yarmulkes, gunlayers, accumbency, butyrates, and quackery"
icky tray	rusting tray	"kayoes, ropeways, geomancy, myelomas, laywomen and soybeans"
icky tray	eyeing tray	"gouaches, taphouses, armourers, outreach, seahounds, buffaloes, leukomas, and flameouts"
ol' tray	rusting tray	"baileys, bikeways, essayists, paisleys, artillery, ancientry, vineyards, Egyptians, hairstyles and machinery"
ol' tray	eyeing tray	"altitudes, audibles, sauteing, jaundice, tequila and thesauri"
rusting tray	eyeing tray	"Bohemia, aerobics, canopies, gasoline, and toadies"

every turn when player is in a trayroom and location of player is unfinished:
	say "You hear seemingly unrelated thoughts of [tray-clue of location of player] here.";

to say tray-clue of (rm - a room):
	repeat through table of trayclues:
		if wt1 of rm is t1 entry and wt2 of rm is t2 entry:
			say "[trayclue entry]";
			continue the action;
		if wt1 of rm is t2 entry and wt2 of rm is t1 entry:
			say "[trayclue entry]";
			continue the action;
	say "BUG ... need to check what happened"

book people

a person has text called talk-text. talk-text of the player is "'You, ooh, yay!' / 'My, I may...'"

a person can be talked-to. a person is usually not talked-to.

check taking a person: say "You may want to take someone along, and you may need to take someone down, but you can't ever physically TAKE a person." instead;

book regions

a region can be playable. a region is usually playable.

book things

a thing can be abstract. a thing is usually not abstract.

a thing has text called use-text.

chapter randscen

randscen is a kind of thing. randscen is scenery.

check taking randscen: say "You don't need any of the silly stuff in [Novel]. It's just there for amusement." instead;

volume initializations / when play begins

section debug stub - not for release

when play begins (this is the set debug variable rule): now debug-state is true; [this needs to be first]

section song initializations

song-list is a list of songs variable.

cur-song-index is a number that varies.

when play begins:
	now last-song is Itty Day Ditty; [this has already been mooted, so we don't have to check for "if ever-song is true"]
	now song-list is the list of all songs in Sing Ing Say;
	sort song-list in random order;

to moot-song (so - a song):
	moot so;
	remove so from song-list, if present;
	if song-index of so < cur-song-index, decrement cur-song-index;
	if cur-song-index > number of entries in song-list, now cur-song-index is 1;

after examining a song:
	now cur-song-index is song-index of noun;
	continue the action;

section main introduction narrative

when play begins (this is the main introductory narrative and initialization rule):
	now right hand status line is "[score]/[conditional-max]";
	force-status;
	now last-helpbook is Aid Fray Fraid;
	process the check-skip-intro rule;
	let skip-stuff be whether or not the rule succeeded;
	if debug-state is false, ask-screenread;
	if skip-stuff is true, continue the action;
	say "You aren't up to much today, but at the same time, part of you wants to do something cool. You feel too lazy to do much more than take out the trash, though. You pitch some junk mail, including something from ... OkayCo? They're a warehouse club, explicitly selling unexciting stuff at low prices. And just a few miles away! And in a neighborhood you'd never been. Exploring is fun.";
	say "[line break]Perfect for the bike-share program, with buses being erratic on weekends. You can zigzag around more easily, ride down an interestingly-named side street. Things are new, but not too new. You remember you DID go by that one place a mile back, many years ago, now... you look around after docking and removing your helmet.[wfak]";
	say "[line break]IKE'S BAY is the name of the bar you're nearby. There's a bus stop here, spray-painted US BAY.";
	say "[line break]But the club is still a couple blocks['] walk away. You take in the names of the streets...[wfak]";
	say "[line break]Will-Ill Way. Worst-Erst Way. You have a look down. It's safe, but you'd still better get back to the main street. But when you loop back to where it should be, things look different...";
	say "[line break]You hear a voice boom 'On?! Pay, pawn!' and 'Up! Pay, pup!' You poke around in your jacket.[paragraph break]'ANY pay!' the voice continues. Thoughtlessly, you pull out a penny and flip it towards the voice. It seems to be the right choice. Your surroundings dissolve again...[wfak]";

section random initialization of trayrooms

when play begins (this is the sort the trays rule):
	repeat with X running through trayrooms:
		let Y be a random not sorted-yet win-tray;
		now wt1 of X is Y;
		now Y is sorted-yet;
		blot-out X and Y;
		let Y be a random not sorted-yet win-tray;
		now wt2 of X is Y;
		now Y is sorted-yet;
		blot-out X and Y;

volume old school verb carnage

understand the command "ask" as something new.
understand the command "attach" as something new.
understand the command "buy" as something new.
understand the command "chop" as something new.
understand the command "crack" as something new.
understand the command "embrace" as something new.
understand the command "fight" as something new.
understand the command "give" as something new.
understand the command "give" as something new.
understand the command "hold" as something new.
understand the command "hop" as something new.
understand the command "hug" as something new.
understand the command "insert" as something new.
understand the command "jump" as something new.
understand the command "kill" as something new.
understand the command "light" as something new.
understand the command "move" as something new.
understand the command "murder" as something new.
understand the command "pay" as something new.
understand the command "polish" as something new.
understand the command "prune" as something new.
understand the command "pull" as something new.
understand the command "punch" as something new.
understand the command "purchase" as something new.
understand the command "push" as something new.
understand the command "put" as something new.
understand the command "say" as something new.
understand the command "scrub" as something new.
understand the command "shine" as something new.
understand the command "show" as something new.
understand the command "sip" as something new.
understand the command "skip" as something new.
understand the command "slice" as something new.
understand the command "sorry" as something new.
understand the command "stand" as something new.
understand the command "swallow" as something new.
understand the command "sweep" as something new.
understand the command "taste" as something new.
understand the command "tell" as something new.
understand the command "tell" as something new.
understand the command "thump" as something new.
understand the command "tie" as something new.
understand the command "torture" as something new.
understand the command "touch" as something new.
understand the command "turn" as something new.
understand the command "wave" as something new.
understand the command "wipe" as something new.
understand the command "wreck" as something new.

volume detailed parsing

chapter stubs

this is the note-keyword rule:
	if note-one-keyword is false:
		bold-note "You had some words in this command you didn't need, beyond keywords. [this-game] only needs a keyword to process what you want. While this may let you spam keywords for a solution and cheat a bit, it will only pick up the first one, and I never want the player to guess the right keyword but get rejected.";
		now note-one-keyword is true;
	else if number of words in player's command > 2:
		bold-note "The parser message below may seem odd--but you've found a keyword in a multi-word command, and when in doubt, I clue them.";

book general

chapter pedantic input details and help

the initial command read rule is listed first in the after reading a command rules.

after reading a command (this is the initial command read rule):
	if in-beta is true and the player's command matches the regular expression "^<;\*>":
		say "(Noted.)[paragraph break]";
		reject the player's command;
	let XX be indexed text;
	process the punctuation-munge rule;
	if the player's command matches the regular expression "<A-Z>":
		now XX is the player's command;
		change the text of the player's command to "[XX in lower case]";
		if note-case-insensitive is false, bold-note "Under They Thunder's parser is case-insensitive, so don't worry about when to use capitals.";
		now note-case-insensitive is true;
	if word number 1 in the player's command is "give" or word number 1 in the player's command is "show":
		if note-give-use is false:
			now note-give-use is true;
			bold-note "SHOW and GIVE are deprecated in favor of U/USE X on Y.";
		if the player's command includes "to":
			now XX is the player's command;
			replace word number 1 in XX with "use";
			repeat with X running from 1 to the number of words in the player's command:
				if word number X in the player's command is "to":
					replace word number X in XX with "on";
					break;
			change the text of the player's command to "[XX]";
		else:
			say "GIVE is deprecated. You will want to use the more generic U or USE.";
			reject the player's command;
	if note-fay-fey is false:
		if the player's command includes "fay" or the player's command includes "fey":
			now note-fay-fey is true;
			bold-note "fay and fey are similar enough that the parser treats them as the same word. There may be other similar spellings it lumps together, but this is the big one.";
	if the player's command includes "fay":
		now XX is the player's command;
		replace the regular expression "\Wfay\W" in XX with "fey";
		change the text of the player's command to "[XX]";
		if debug-state is true, say "DEBUG fay-fey [XX].";
	if the player's command matches the regular expression "^say ":
		if note-say-zapped is false:
			now note-say-zapped is true;
			bold-note "you never need to SAY anything. Just type it in. In other words, WHOAH is the same as SAY WHOAH. Under They Thunder will cut SAY off of the start of all commands.";
			now XX is the player's command;
			replace the regular expression "^say +" in XX with "";
			change the text of the player's command to XX;
	if eat chez sheet is touchable and the player's command includes "eat":
		if note-say-eat is false:
			now note-say-eat is true;
			bold-note "[this-game] assumes 'eat' as part of the locations you need to look for, here, so you don't have to worry about typing that.";
			now XX is the player's command;
			replace the regular expression "\beat\b" in XX with "";
			change the text of the player's command to XX;

chapter up vs u

after reading a command (this is the use vs up for u rule):
	if the player's command exactly matches the text "u":
		try going up;
		reject the player's command;

book specific rooms

rule for printing a parser error when mrlp is Am Hey Ham and sco-use-moil-che is false:	
	if the player's command includes "breach":
		say "Good idea. You'd think Breach Reach Bay would be a location, but somehow I forgot to put it in. There actually is one location that gets renamed to that, but you can't warp to it.[paragraph break]As-is, Breach Reach Bay might allow the [flame] to find a way into OkayCo. That's why I didn't allow it. Yeah, that's the ticket." instead;
	continue the action;

chapter Bless Less Bay / Boil Oil Bay

rule for printing a parser error when can-get-oil (this is the fill dice with oil rule):
	let cur-index be 0;
	repeat through the table of oil guesses:
		if can-work entry is true, increment cur-index;
		let Q be 0;
		increase Q by boolval of whether or not the player's command matches the regular expression "(^|\W)([w2 entry])($|\W)";
		if Q is 0, next;
		if Q is 2 and note-one-dice is false:
			bold-note "For future reference, you only need to specify one word of the sort of oil you think is in the bay.";
			now note-one-dice is true;
		if number of words in the player's command > Q, process the note-keyword rule;
		if can-work entry is false:
			if ice day dice is allscored, say "(Still allowing good guesses even though you've completed the Ice Day Dice) ";
			process the oil-check entry;
			if tried-yet entry is false:
				process the new-good-guess rule;
			now tried-yet entry is true;
			if opt-ease-play is true, show-please-point cur-index and ice day dice;
			the rule fails;
		if ice day dice is allscored, say "[bless less bay] isn't in its boil-oil state any more, so you don't need to look for more." instead;
		if worked-yet entry is true:
			say "No need to double-dip.";
			the rule fails;
		now worked-yet entry is true;
		if there is an eat-item entry, now player has eat-item entry;
		process the oil-check entry;
		increment the score;
		process the notify score changes rule;
		the rule succeeds;
	if the player's command includes "oil", say "[if ice day dice is allscored]You've done what you needed with the oil[else]You have to decide what to do with the oil, though. What to make of it, what to change it into[end if].";
	continue the action;

to show-please-point (mynum - a number) and (mylat - a latinable):
	say "A ray shoots out from the [please] to ";
	if mynum is 0:
		say "behind the first [clue-chunk of mylat] of [the mylat]";
	else if mynum is total-score of mylat:
		say "past the last [clue-chunk of mylat] of [the mylat]";
	else:
		say "between [clue-chunk-plural of mylat] number [mynum in words] and [(mynum + 1) in words] of [the mylat]";

chapter boats / Oats Bay / hip say ship

to say firstof of (tx - text):
	let tx2 be indexed text;
	now tx2 is "[tx]";
	replace the regular expression "\|.*" in tx2 with "";
	say "[tx2 in title case]";

rule for printing a parser error when hip say ship is touchable (this is the process isle guesses rule):
	let cur-index be 0;
	repeat through the table of isle guesses:
		if can-work entry is true, increment cur-index;
		let Q be 0;
		increase Q by boolval of whether or not the player's command matches the regular expression "(^|\W)([w1 entry])($|\W)";
		[say "[w1 entry] [w2 entry] [Q].";]
		increase Q by boolval of whether or not the player's command matches the regular expression "(^|\W)([w2 entry])($|\W)";
		[say "[w1 entry] [w2 entry] [Q].";]
		if Q is 0, next;
		if Q is 2 and note-one-isle is false:
			bold-note "For future reference, you only need to specify one word of the isle you wish to go to.";
			now note-one-isle is true;
		if number of words in the player's command > Q, process the note-keyword rule;
		if opt-block-done is true:
			if debug-state is true, say "Checking [block-room-rule of myrm entry] for [myrm entry].";
			abide by the blockcheck rule for myrm entry;
		if w1 entry is "away":
			if did-whale-exhaust is false:
				say "You don't need to get away to recuperate [if blower is moot]any more[else]right now[one of], but you make a note for later[or][stopping][end if].";
				now tried-yet entry is true;
				the rule succeeds;
		else if did-whale-exhaust is true:
			say "You want to go somewhere, but that feels too challenging right now, physically and mentally.";
			now tried-yet entry is true;
			the rule succeeds;
		if there is no myrm entry:
			say "[first-trip entry][line break]";
			if tried-yet entry is false:
				now tried-yet entry is true;
				process the new-good-guess rule;
			if opt-ease-play is true, show-please-point cur-index and hip say ship;
			the rule succeeds;
		if myrm entry is location of player, say "You already are here!" instead;
		if myrm entry is Isle Tray Trial:
			if player is in Beast East Bay or player is in West Est Way, say "You don't need to take the [ship] to get to [tray trial]." instead;
		now tried-yet entry is false;
		say "[if worked-yet entry is false][first-trip entry][paragraph break]And the [ship] sails off to somewhere new. ";
		if hip say ship is unscored:
			say "It's a nice voyage. You never even consider saying 'Ick, say, sick!'";
			bold-note "By the way, you can type [b]SHIP[r] to go back to the mainland, or you can guess at another isle.";
		else if worked-yet entry is true:
			say "Back to [myrm entry]...";
		else:
			say "[line break]";
		if worked-yet entry is false, increment the score;
		now worked-yet entry is true;
		if myrm entry is Isle Fey File, now did-visit-fey-file is true;
		move hip say ship to myrm entry;
		move player to myrm entry;
		process the notify score changes rule;
		reject the player's command;
	continue the action;

global-good-guesses is a number that varies.
total-good-guesses is a number that varies

this is the new-good-guess rule:
	increment global-good-guesses;
	increment total-good-guesses;
	if debug-state is true, say "DEBUG: incrementing global good guesses.";
	if total-good-guesses is 1, say "[line break]Hmm. A little disappointing. You were proud of that guess, but it didn't have any results. Perhaps you just need to keep trying. Eventually something will work. And who knows? Some thoughtful soul, who only helps adventurers who help themselves, might appreciate your efforts that don't quite pan out.";
	if global-good-guesses is 5:
		if id say side is off-stage:
			now did-activate-id-say-side is true;
		else:
			say "[line break]You feel semi-frustrated. You must be on the right track. Perhaps you can check with [cheater] again.";
	if total-good-guesses is 15:
		say "[line break]Hey! What's this? An [eyeing tray]! You're not sure what it's doing here, but it doesn't look too heavy. You take it.";
		now player has eyeing tray;

after printing the locale description when player is in Start Art Stay (this is the open id say side rule):
	if did-activate-id-say-side is true and did-acknowledge-id-say-side is false:
		now did-acknowledge-id-say-side is true;
		say "Frustrated some of your good guesses didn't pan out, you let our eyes wander. Wait. That part of the wall looks funny. There's a hidden latch. And oh, you can pull right there and ... you discover a passage, called an I'd Say Side. Wow! You can ENTER it, if you want.";
		move id say side to Start Art Stay;
		now Start Art Stay is mapped outside Ere Say Seer;
	continue the action;

after printing the locale description when player is in Start Art Stay (this is the ray fey rule):
	if did-visit-fey-file is true and Frowned Round Fey is not rayable:
		say "Before you forget, you call out to Ernie J and inform him about what you saw on Isle Fey File. He calls in two of the Raye brothers, who tinker with the settings. After a few checks, they deem it good to go. There are high fives all around before they leave.";
		now Frowned Round Fey is rayable;
	continue the action;

chapter eat chez sheet

[this is pretty simple, as you just pick up items when you putz around here.]

rule for printing a parser error when player is in What Hut Way and eat chez sheet is touchable (this is the check for eat guesses rule):
	let cur-index be 0;
	repeat through table of eat chez sheet guesses:
		if can-work entry is true, increment cur-index;
		let Q be 0;
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w1 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words/1.";]
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w2 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words /2.";]
		if Q is 0, next;
		if Q is 2 and note-one-eat is false:
			bold-note "You don't need both words to find a hut the [sheet] refers to.";
			now note-one-eat is true;
		if number of words in the player's command > Q, process the note-keyword rule;
		if can-work entry is false:
			process the set-rule entry;
			if tried-yet entry is false:
				process the new-good-guess rule;
			now tried-yet entry is true;
			if opt-ease-play is true, show-please-point cur-index and eat chez sheet;
			the rule fails;
		if worked-yet entry is true:
			say "No need to double-dip.";
			the rule fails;
		now worked-yet entry is true;
		if there is an eat-item entry, now player has eat-item entry;
		process the set-rule entry;
		increment the score;
		process the notify score changes rule;
		the rule succeeds;
	continue the action;

chapter Sci I Say

this is the note-ray-breaks rule:
	if ray-needs-rod, say "[line break]Besides, your first priority is to replace the component of the [raid] that shorted out." instead;
	if ray-needs-rile, say "[line break]Besides, your first priority is to recharge the ray's energy." instead;

rule for printing a parser error when player is in Sci I Say (this is the check for ray guesses rule):
	let temp-row be 0;
	let change-mood be false;
	let got-ray-match be false;
	let cur-index be 0;
	repeat through table of Raid Aid Ray guesses:
		increment temp-row;
		let Q be 0;
		if can-work entry is true, increment cur-index;
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w1 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words/1.";]
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w2 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words /2.";]
		if Q is 0, next;
		if Q is 2 and note-one-ray is false:
			now note-one-ray is true;
			bold-note "For future reference, you only need to specify half of the ray's new setting. So, for instance, [b]REACH[r] or [b]EACH[r] alone would suffice to set the [raid aid ray] to [b]REACH EACH[r], if there weren't already such a ray.";
		if number of words in the player's command > Q, process the note-keyword rule;
		if is-set entry is true:
			say "The [raid aid ray] is already set that way.";
			process the note-ray-breaks rule;
			reject the player's command;
		if can-work entry is false:
			process the set-rule entry;
			process the note-ray-breaks rule;
			if tried-yet entry is false:
				now tried-yet entry is true;
				process the new-good-guess rule;
			if opt-ease-play is true, show-please-point cur-index and raid aid ray;
			the rule fails;
		if there is a finished-with entry:
			process the finished-with entry;
			if the rule succeeded:
				say "You don't need to set the ray to [firstof of w1 entry]/[firstof of w2 entry] any more[if not ray-is-working], and it's temporarily broken, anyway[end if].";
				reject the player's command;
		if there is a done-rule entry:
			process the done-rule entry;
			if the rule failed:
				process the note-ray-breaks rule;
				the rule succeeds;
		if ray-needs-rile or ray-needs-rod:
			if worked-yet entry is false:
				say "Yes. That's an idea. A good one. You note it to THINK about later. But you need to fix the ray first.";
				process the new-good-guess rule;
				now tried-yet entry is true;
			else:
				say "You can't try that again until you fix the ray.";
			reject the player's command;
		process the set-rule entry;
		if the rule failed:
			process the note-ray-breaks rule;
			if can-work entry is false and worked-yet entry is false:
				now worked-yet entry is true;
				process the new-good-guess rule;
			reject the player's command;
		now got-ray-match is true;
		if debug-state is true, say "DEBUG MOOD: [if there is a desc-text entry]S[else]Not s[end if]etting mood for [firstof of w1 entry]/[firstof of w2 entry].";
		if there is a desc-text entry:
			now change-mood is true;
			now did-raid-aid-mood is true;
		if worked-yet entry is false:
			increment ray-guesses-found;
			increment the score;
			if ray-guesses-found is ray-guesses-break:
				say "[line break]Uh oh. A horrible grinding, and the ray begins ringing. Yes, it is a ring-ing ray. But it doesn't look totally broken.[paragraph break]Ernie J stops by. 'Ugh... the Raye brothers [if raid aid ray is not examined](they're the folks who made the ray) [end if]told me this might happen. They mentioned their reclusive brother had a stop-gap fail-safe to start it going again. But he never got around to bringing it in. So I guess you have to go find it.'";
				now did-break-ray is true;
				now raid aid ray is needy;
		now worked-yet entry is true;
		now tried-yet entry is false;
		if did-raid-aid-ray is false:
			say "[line break]Crrk! You hear the grinding of gears. Ernie J calls to you: 'Nice work! Since you've shown you can work with the ray, maybe you'll be able to do something to the east[if opt-stay-stop is true]--well, if you are up for the BIG adventure[end if]. I didn't want to open it until you got started. Throwing too much at you at once, and all that sort of thing.'[paragraph break]The Raid Aid Ray itself begins humming. It's a rumble-[']umble ray, now, as it's going to help you get places.";
			now did-raid-aid-ray is true;
		process the notify score changes rule;
		break;
	if change-mood is true:
		let temp-row-2 be 0;
		repeat through table of Raid Aid Ray guesses:
			increment temp-row-2;
			unless there is a desc-text entry, next;
			process the finished-with entry;
			if is-set entry is true and temp-row-2 is not temp-row, say "[line break]Your [desc-text entry] feeling wears off, but [if the rule succeeded] it's just as well. You probably don't need it any more[else]you imagine the Raid-Aid Ray can bring it back[end if].";
			now is-set entry is whether or not temp-row-2 is temp-row;
		reject the player's command;
	if got-ray-match is false, continue the action;

chapter Ankh Bay Bank

rule for printing a parser error when player has ankh bay bank (this is the ankh morph rule):
	let cur-index be 0;
	repeat through table of Ankh Bay Bank guesses:
		if can-work entry is true, increment cur-index;
		let Q be 0;
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w1 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words/1.";]
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w2 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words /2.";]
		if Q is 0, next;
		if Q is 2 and note-one-ankh is false:
			bold-note "You don't need both words to activate the ankh.";
			now note-one-ankh is true;
		if number of words in the player's command > Q, process the note-keyword rule;
		process the ankh-check entry;
		if the rule failed:
			if can-work entry is false and tried-yet entry is false:
				now tried-yet entry is true;
				process the new-good-guess rule;
				if opt-ease-play is true, show-please-point cur-index and ankh bay bank;
			the rule fails;
		if the rule succeeded: [this should always happen]
			increment the score;
			now worked-yet entry is true;
			process the notify score changes rule;
			the rule succeeds;
		say "WARNING: [ankh-check entry] had no outcome. This should not affect gameplay, but it's a small coding bug I'd like to know about at [email].";
		the rule succeeds;
	continue the action;

chapter Odd Pay Pod

rule for printing a parser error when player is in brat at brae and Odd Pay Pod is in brat at brae (this is the find in Odd Pay Pod rule):
	let temp-row be 0;
	repeat through table of Odd Pay Pod guesses:
		increment temp-row;
		let Q be 0;
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w1 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words/1.";]
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w2 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words /2.";]
		if Q is 0, next;
		if Q is 2 and note-one-pile is false:
			bold-note "You don't need both words to ask what to buy in the [pile].";
			now note-one-pile is true;
		if number of words in the player's command > Q, process the note-keyword rule;
		if player does not have old gay gold:
			say "Maybe you can try that when you have some currency[if can-work entry is false], though it might not work[end if].";
			now tried-yet entry is true;
			process the new-good-guess rule;
			the rule fails;
		process the pile-check entry;
		if the rule failed:
			if can-work entry is false and tried-yet entry is false:
				now tried-yet entry is true;
				process the new-good-guess rule;
			the rule fails;
		if the rule succeeded: [this should always happen]
			increment the score;
			now worked-yet entry is true;
			if Odd Pay Pod is allscored:
				say "[paul] laughs at you as you hand over the final bit of your old gay gold. 'That's all I have. I've ripped you off enough. Thanks, sucker. Here's something so you don't get ripped off next time.' He hands you a [aid tray].";
				moot paul;
				moot Odd Pay Pod;
				moot old gay gold;
				now player has trade aid tray;
			else if got-score of Odd Pay Pod is 2:
				say "'Thanks for helping me get rid of some junk, I mean, excess inventory.' Paul waves a hand, and the west section of the Roof-Pay-Proof collapses.[paragraph break]You can now go west.";
				now did-west-brat is true;
			else if got-score of Odd Pay Pod is 4:
				say "'Thanks for helping me get rid of some more junk, I mean, excess inventory.' Paul waves a hand, and the east section of the Roof-Pay-Proof collapses.[paragraph break]You can now go east as well as west.";
				now did-east-brat is true;
			process the notify score changes rule;
			the rule succeeds;
		say "WARNING: [pile-check entry] had no outcome. This should not affect gameplay, but it's a small coding bug I'd like to know about at [email].";
		the rule succeeds;
	continue the action;

chapter Stall Say Tall

rule for printing a parser error when player is in Fear Ere Fey and sco-use-plant-tractor is true (this is the find animals for stall rule):
	let temp-row be 0;
	repeat through table of Stall guesses:
		increment temp-row;
		let Q be 0;
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w1 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words/1.";]
		increase Q by boolval of whether or not the player's command matches the regular expression "\b([w2 entry])\b";
		[if debug-state is true, say "DEBUG: ray [Q] words /2.";]
		if Q is 0, next;
		if Q is 2 and note-one-stall is false:
			bold-note "You don't need both words to summon an animal to the stall.";
			now note-one-stall is true;
		if number of words in the player's command > Q, process the note-keyword rule;
		if can-work entry is false:
			process the stall-check entry;
			if tried-yet entry is false:
				process the new-good-guess rule;
			now tried-yet entry is true;
			the rule fails;
		if worked-yet entry is true:
			say "No need to double-dip.";
			the rule fails;
		now worked-yet entry is true;
		if there is an eat-item entry, now player has eat-item entry;
		process the stall-check entry;
		if tall say stall is allscored:
			say "[line break]And what's this? A rusty tray clatters out from the [tall]. You take the tray.";
			now player has rusting tray;
		increment the score;
		process the notify score changes rule;
		the rule succeeds;
	continue the action;

book general errors (put here for order--"is listed last" doesn't seem to work so well)

chapter general parser errors [xxparserr]

rule for printing a parser error when the latest parser error is the can't see any such thing error:
	abide by the error-bail rule;
	say "The verb was recognized, but the subject didn't quite work. If you're trying to interact with scenery, it's usually not important in this game."

rule for printing a parser error when the latest parser error is the didn't understand error:
	abide by the error-bail rule;
	say "Sorry, that command may work somewhere or sometime else, but not here and now."

rule for printing a parser error when the latest parser error is the i beg your pardon error:
	say "Um... say some?"

rule for printing a parser error when the latest parser error is the not a verb i recognise error (this is the generic unrecognized verb rule):
	if player is in Oats Bay and hip say ship is not off-stage, say "The [ship] remains motionless. That may not be an isle you need to go to." instead;
	if player is in Sci I Say:
		say "The Raid Aid Ray ";
		if character number 1 in the player's command is "r":
			say "chugs a bit. You must be on the right track.";
		else if character number 1 in the player's command is "w" and character number 2 in the player's command is "r":
			say "bleeps a bit, as if to say it's emphatically NOT a Writ-It Wray. Err, ray.";
		else:
			say "makes a small r-r-r noise, as if to give you a start on what sort of settings work here. It seems to be reading your mind even when you think nonsense.";
		the rule succeeds;
	repeat with reg running through omable any-visited regions:
		if word number 1 in the player's command is "[reach-abbrev of reg]":
			if player is not in Start Art Stay, say "You can only [b][word number 1 in the player's command in upper case][r] back at [start]. [if reg is mrlp]And anyway, that'd be jumping in place[else]But you can just OM first[end if]." instead;
			now noun is last-room of reg;
			move the player to last-room of reg;
			say "Wow! That was instantaneous, too. Maybe that will be a help some time in the future."; [?? uh oh. This technically *should* take a move.]
			process the Blown Lone guard reorg rule;
			now ever-reach-abbrev is true;
			the rule succeeds;
	abide by the error-bail rule;
	if player is in Ere Say Seer:
		say "The format to ask for help from [cheater] is [b](letter) (number)[r], e.g. [b]R 4[r] or [b]I 3[r]. Other than that, you need no unusual verbs here." instead;
	say "I didn't recognize that verb. [this-game] uses a stripped-down parser so you can save your verb-guessing energy for certain puzzles. You may also wish to look at [b]VERBS[r] or [b]V[r] to see other important regular verbs.[paragraph break]And if you want to use an item but don't know how, [this-game] generally looks for U or USE. You can USE an item on its own, or USE X ON Y.";
	the rule succeeds;

rule for printing a parser error when the latest parser error is the noun did not make sense in that context error:
	if reach each ray is in location of player: [ "touchable" doesn't seem to work ]
		if word number 1 in the player's command is "r" or word number 1 in the player's command is "reach":
			say "That place isn't shown in the [heart art]. If you tried to visit a region, that is potentially too ambiguous.";
			the rule succeeds;
	abide by the error-bail rule;
	say "The verb was okay, but the subject didn't quite work."

rule for printing a parser error when the latest parser error is the only understood as far as error:
	if word number 1 in the player's command is "ship" and hip say ship is touchable:
		say "You just need to guess the name of the isle[if hip say ship is unscored]. There is a pattern, and once you guess one, others will probably fall[end if].";
		the rule succeeds;
	continue the action;

[zzparserr]

volume meta-region

Oozeless Yay is a not playable region.

Aced Way is a room in Oozeless Yay. "You should never see this, because it is a meta-room."

to moot (th - a thing): move th to Aced Way.

to mootl (lt - a list of things): [the Haye brothers]
	repeat with Q running through lt:
		moot Q;

volume global variables and tests

section error bail

bail-on-error is a truth state that varies.

this is the error-bail rule: [ this cannot go to the TESTS module or we will get a compiler error ]
	if bail-on-error is true:
		say "This is probably a test run, so we are bailing on an error here.";
		end the story saying "Oops, Hey, Hoops";
		follow the shutdown rules;
		the rule succeeds;

book score

the maximum score is 144.

book game state globals

last-out-room is a room that varies. last-out-room is usually Start Art Stay. [this is very wrong, but it quickly gets re-initialized before we need it]

section conditional line breaks for conditional text

temp-conditional-line-break is a truth state that varies.

chapter player note globals

note-om-mo is a truth state that varies. ever-om-mo is a truth state that varies.
note-rchar-commands is a truth state that varies.

ever-reach-abbrev is a truth state that varies.

chapter parser note globals

[these check if we've notified the user about shortcuts etc.]

note-case-insensitive is a truth state that varies.
note-fay-fey is a truth state that varies.
note-give-use is a truth state that varies.
note-punc-flag is a truth state that varies.
note-say-zapped is a truth state that varies.
note-say-eat is a truth state that varies.

note-one-ankh is a truth state that varies.
note-one-eat is a truth state that varies.
note-one-keyword is a truth state that varies.
note-one-ray is a truth state that varies.
note-one-isle is a truth state that varies.
note-one-pile is a truth state that varies.
note-one-dice is a truth state that varies.
note-one-stall is a truth state that varies.

chapter option globals

opt-stay-stop is a truth state that varies.
opt-ease-play is a truth state that varies. ever-ease-play is a truth state that varies.

opt-short-names is a truth state that varies.
opt-block-done is a truth state that varies.
opt-track-done is a truth state that varies.

opt-hinter-reading is a truth state that varies.

chapter scoring or progress globals

section miscellaneous actions tried

did-skip-ankh-points is a truth state that varies.
did-skip-ankh is a truth state that varies.

did-talk-sham is a truth state that varies. [nothing in the 'Ovel is worthwhile]

did-finish-sample is a truth state that varies.
sample-row is a number that varies. sample-row is 0.

ray-guesses-found is a number that varies.
ray-guesses-break is a number that varies. ray-guesses-break is 2.

wait-count is a number that varies.

did-activate-id-say-side is a truth state that varies.
did-acknowledge-id-say-side is a truth state that varies.

did-hey-hop is a truth state that varies.
did-spread-taunt is a truth state that varies.

section general game progress

[these are boolean statuses for the Raid Aid Ray]
did-ramp-amp is a truth state that varies. [did you specifically amp the ramp?]
did-rake-ache is a truth state that varies. [did you specifically get the rake?]
did-rabbit-abbot is a truth state that varies. [did you specifically get the rabbit/bunny?]
did-ropin-open is a truth state that varies.

noclue-count is a number that varies. [the end bit]

did-break-ray is a truth state that varies. [did you find enough settings to break the ray?]

did-talk-should is a truth state that varies. [need to talk to HSH twice]

did-use-covert is a truth state that varies.

did-east-berth is a truth state that varies. [did you connect the corners of Brain Reign Bay?]

did-visit-fey-file is a truth state that varies.

did-whale-exhaust is a truth state that varies. [are you currently exhausted from pushing the whale?]

did-east-brat is a truth state that varies.
did-west-brat is a truth state that varies.

did-ever-song is a truth state that varies.

[section booleans]

did-raid-aid-mood is a truth state that varies. [this says, did you ever find a ray mood setting?]
did-raid-aid-ray is a truth state that varies. [this says, did you ever find a ray setting? It could be in sco, but this is a general point.]
did-ray-ankh is a truth state that varies. [did you summon the ankh? This is equivalent to "ankh is not off-stage."]
did-raid-aid-south is a truth state that varies. [this says, did you find enough settings to open the way south?]
did-ropin-open-unlock is a truth state that varies. [this says, are you able to get the rope to use?]

did-use-power-cam is a truth state that varies. [8]
did-use-power-flab is a truth state that varies. [32]
did-use-power-saw is a truth state that varies. [16]
did-use-power-visor is a truth state that varies. [4]

did-bless-visit is a truth state that varies.

did-see-axe is a truth state that varies.

did-warn-sing is a truth state that varies.
did-warn-novel is a truth state that varies.

section game state

sta-switch-that is a truth state that varies.
sta-just-used-ship is a truth state that varies.

sta-just-fixed-ray is a truth state that varies.

sta-announced-trays is a truth state that varies.

section chase stuff

last-chase-direction is a direction that varies. last-chase-direction is usually up.

count-this-turn is a truth state that varies.

sta-chase-b is a truth state that varies.
sta-chase-c is a truth state that varies.

to start-the-chase:
	now last-chase-direction is up;
	now start-of-chase is true;

to end-the-chase:
	process the flip-room-name rule;
	if sta-chase-b is true, move cur-chaser to Blown Lone Bay;
	if sta-chase-c is true, move cur-chaser to bricky icky brae;
	now sta-chase-b is false;
	now sta-chase-c is false;

room-to-flip is a room that varies. room-to-flip is usually Start Art Stay.

start-of-chase is a truth state that varies.

every turn when wait-count > 0 (this is the chase and wait rule):
	if count-this-turn is false:
		if debug-state is true, say "DEBUG: not counting, wait-count still [wait-count].";
		continue the action;
	decrement wait-count;
	if player is in Ere Nay Near:
		say "The number above the [wait] decreases to [wait-count][if wait-count is 0]. The [wait] flips back up again[end if].";
	else if debug-state is true:
		say "DEBUG: wait-count = [wait-count].";
	if not in-any-chase, continue the action;
	if debug-state is true:
		say "[wait-count] = moves left in wait-count.";
		if sta-chase-b is true, say "PLAYER IN [location of player], CHASE ACE CHE IN [location of chase ace che].";
		if sta-chase-c is true, say "PLAYER IN [location of player], IMP PREY PRIMP IN [location of imp prey primp].";

every turn when in-any-chase (this is the in current chase rule):
	if count-this-turn is false:
		if debug-state is true, say "DEBUG: passing [cur-chaser] move, wait-count still [wait-count].";
		continue the action;
	if start-of-chase is true:
		now start-of-chase is false;
		continue the action;
	if wait-count is 0:
		if sta-chase-b is true, abide by the win-b-chase rule;
		if sta-chase-c is true, abide by the win-c-chase rule;
	if location of player is not location of cur-chaser:
		say "[cur-chaser] chases from behind.";
		move cur-chaser to location of player;
	else:
		if cur-chaser is imp prey primp:
			say "The [primp] roughs you up a bit once it catches up, then leaves you there. It poses a bit, then [if player is in bricky icky brae] Walks back to where it was [else]returns, probably to the [bricky]. Perhaps it wants to save some 'fun' for later.";
		else if cur-chaser is Chase Ace Che:
			say "[chase] [if player is in blown lone bay]shrugs. 'A bit of a false start there[else]catches up to you. 'Well, you didn't beat me that time[end if], but I'm always up for more.'";
		end-the-chase;
	if sta-chase-b is true, abide by the lose-b-chase rule;
	if sta-chase-c is true, abide by the lose-c-chase rule;

every turn when count-this-turn is false:
	now count-this-turn is true;
	continue the action;

section win and lose rules

this is the lose-c-chase rule:
	if player is in cornery ornery cay:
		say "Unfortunately, [if churchin is in cornery ornery cay][churchin] drags you back. There'll be none of that running around horseplay around HIM! [primp] catches up to you and gaffles you a bit before returning to [bricky][else][primp] recognizes the ability to summon friends in the [cornery].";
		end-the-chase;
		the rule succeeds;

this is the lose-b-chase rule:
	if player is in booze ooze bay or player is in blurring luring bay or player is in was us way or player is in waffle awful way:
		say "Unfortunately, as you went around the corner, [chase] was able to cut the corner and catch up with you. 'Not a bad race at all,' he says, 'but not good enough.'";
		end-the-chase;
		the rule succeeds;

this is the win-b-chase rule:
	if debug-state is true, say "DEBUG: checking (B) chase.";
	if player is in Whacks Axe Way and Whacks Axe Way is altnamed:
		say "The Wax Axe becomes a Whacks Axe and swipes hard at [chase], who yells in pain. It doesn't cause any permanent damage, but it is embarrassing. 'Well, I respect whatever it is you did. But you're still a bit out of shape compared to me. Still, I'd like you to have this.' He hands you an [ag bay bag], which looks ... nutritious, at least, and a [grunt], which is meant to make exercise more pleasant. Or less unpleasant. Whichever.";
		moot chase ace che;
		increment the score; [cmd: outrun Chase Ace Che]
		now sta-chase-b is false;
		now player has runt gay grunt;
		now player has ag bay bag;
		the rule succeeds;
	

this is the win-c-chase rule:
	if debug-state is true, say "DEBUG: checking (C) chase: Right location: [whether or not player is in claim lame cay] Altnamed: [whether or not claim lame cay is altnamed] [room-to-flip].";
	if player is in claim lame cay and claim lame cay is altnamed and room-to-flip is claim lame cay:
		say "You did it! [primp] runs eagerly into [claim], but at that moment, the [wait] kicks in, changing it to Claim Lame Cay. Which is too lame for [primp]. It pulls out a [visor] to make sure there's nothing here, that you're not sneaking something past it, but throws the [visor] down in a rage when nothing is revealed. 'What is wrong with this place? What is wrong with you? It's just ... wrong, to mislead me like this.' The [primp], wanting nothing more to do with you, stomps off, disgusted, through some diagonal passage into the foliage where you can't disturb it.[paragraph break]But it left its visor! So you take it.";
		moot imp prey primp;
		now claim lame cay is not altnamed;
		increment the score; [cmd: outrun Imp Prey Primp]
		now player has i survey visor;
		now sta-chase-c is false;
		the rule succeeds;

to say chase-mulligan: now count-this-turn is false;

check going when in-any-chase:
	if noun is opposite of last-chase-direction, say "[chase-mulligan]But then [cur-chaser] would catch you." instead;

after going when in-any-chase:
	now last-chase-direction is noun;
	continue the action;

chapter specific scoring globals

section standard verb points

sco-enter-stale is a truth state that varies.

section verb guessing points [xxscovg]

sco-vg-boats is a truth state that varies.
sco-vg-clod is a truth state that varies.
sco-vg-mj is a truth state that varies.

sco-vg-clamber is a truth state that varies.
sco-vg-clues is a truth state that varies.

[zzscovg]

section use points

sco-talk-quiet is a truth state that varies.
sco-talk-cross is a truth state that varies.
sco-talk-mc is a truth state that varies.
sco-talk-prude is a truth state that varies.
sco-talk-should is a truth state that varies.
sco-talk-dork is a truth state that varies.
sco-talk-thump is a truth state that varies.
sco-talk-self is a truth state that varies.
sco-talk-shame is a truth state that varies.
sco-talk-fears is a truth state that varies.
sco-talk-sid is a truth state that varies.
sco-talk-bryce is a truth state that varies.
sco-talk-simp is a truth state that varies.
sco-talk-skid is a truth state that varies.
sco-talk-stim is a truth state that varies.

sco-use-bat is a truth state that varies.
sco-use-clod-sleek is a truth state that varies.
sco-use-phone is a truth state that varies.
sco-use-day-doll is a truth state that varies.
sco-use-cup-keg is a truth state that varies.
sco-use-clever is a truth state that varies.
sco-use-gem is a truth state that varies.
sco-use-broil is a truth state that varies.
sco-use-clear-ear-clay is a truth state that varies.

sco-use-rod-ray is a truth state that varies.
sco-got-stew is a truth state that varies.

sco-ankh-clank is a truth state that varies. [did you clank in Cheap Heap Cay?]
sco-ankh-plank is a truth state that varies.
sco-ankh-prank is a truth state that varies.
sco-ankh-flank is a truth state that varies.

sco-ray-roil is a truth state that varies.
sco-rend-end is a truth state that varies.

sco-use-hoarder-clutter is a truth state that varies.
sco-use-spot-feedin is a truth state that varies.
sco-use-cable-blower is a truth state that varies.
sco-use-frock-stark is a truth state that varies.
sco-use-oafy-tray-emlyn is a truth state that varies.
sco-use-cliffy-cracked is a truth state that varies.
sco-use-sprawl-creep is a truth state that varies.
sco-use-plant-tractor is a truth state that varies.
sco-use-function-cliffy is a truth state that varies.
sco-use-may-more-sprawl is a truth state that varies.
sco-use-stick-clumsy is a truth state that varies.
sco-use-plus-churchin is a truth state that varies.
sco-use-gizmo-jelly is a truth state that varies.
sco-use-grunt-flab is a truth state that varies.
sco-use-bugs-stork is a truth state that varies.
sco-use-sprawl-flea is a truth state that varies.
sco-use-rover-clamp-clay is a truth state that varies.
sco-use-seat-greedy is a truth state that varies.
sco-use-treat-greedy is a truth state that varies.
sco-use-stew-greedy is a truth state that varies.
sco-use-string-hark is a truth state that varies.
sco-use-wedge-mark is a truth state that varies.
sco-use-grail-punk is a truth state that varies.
sco-use-drum-drunk is a truth state that varies.
sco-use-lit-jay is a truth state that varies.
sco-use-sod-brute is a truth state that varies.
sco-use-stern-sophie is a truth state that varies.
sco-use-cliffy-small is a truth state that varies.
sco-use-plots-pork is a truth state that varies.
sco-use-flu-bark is a truth state that varies.
sco-use-saw-slumber is a truth state that varies.
sco-use-foil-proof is a truth state that varies.
sco-use-proof-falter is a truth state that varies.
sco-use-visor-blot is a truth state that varies.
sco-use-bait-howl is a truth state that varies.
sco-use-salt-slot is a truth state that varies.
sco-use-prattle-slot is a truth state that varies.
sco-use-loyal-lovin is a truth state that varies.
sco-use-pole-hold is a truth state that varies.
sco-use-grows-smell is a truth state that varies.
sco-use-dove-swill is a truth state that varies.
sco-use-pole-sink is a truth state that varies.
sco-use-quill-stink is a truth state that varies.
sco-use-slop-march is a truth state that varies.
sco-use-lever-stone is a truth state that varies.
sco-use-moil-che is a truth state that varies.
sco-use-replace-this is a truth state that varies.
sco-use-cam-dad is a truth state that varies.
sco-use-cam-fleet is a truth state that varies.

section think flags

think-vg-mj is a truth state that varies.
think-use-phone is a truth state that varies.
think-use-clever is a truth state that varies.
think-ankh-clank is a truth state that varies.
think-ankh-flank is a truth state that varies.
think-ankh-prank is a truth state that varies.
think-rod-ray is a truth state that varies.
think-stick-clumsy is a truth state that varies.
think-plus-churchin is a truth state that varies.
think-string-hark is a truth state that varies.
think-lit-jay is a truth state that varies.
think-cliffy-small is a truth state that varies.
think-saw-slumber is a truth state that varies.
think-proof-falter is a truth state that varies.
think-foil-proof is a truth state that varies.
think-visor-blot is a truth state that varies.
think-pole-hold is a truth state that varies.
think-seat-greedy is a truth state that varies.
think-rend-end is a truth state that varies.
think-function-cliffy is a truth state that varies.

section find flags

clay-in-clear is a truth state that varies.
did-rename-clear is a truth state that varies.

Under They Thunder Globals ends here.

---- DOCUMENTATION ----
